<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class VirtualCard extends Model
{
    protected $fillable = [
        'user_id', 'card_number', 'card_holder_name', 'expiry_month', 
        'expiry_year', 'cvv', 'balance', 'daily_limit', 'monthly_limit', 
        'status', 'card_type'
    ];

    protected $casts = [
        'balance' => 'decimal:2',
        'daily_limit' => 'decimal:2',
        'monthly_limit' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function transactions()
    {
        return $this->hasMany(VirtualCardTransaction::class);
    }

    public function getMaskedCardNumberAttribute()
    {
        return '**** **** **** ' . substr($this->card_number, -4);
    }

    public function getFormattedCardNumberAttribute()
    {
        return chunk_split($this->card_number, 4, ' ');
    }

    public function isExpired()
    {
        $expiry = Carbon::createFromDate($this->expiry_year, $this->expiry_month, 1)->endOfMonth();
        return Carbon::now()->gt($expiry);
    }

    public function isActive()
    {
        return $this->status === 'active' && !$this->isExpired();
    }

    public function canSpend($amount)
    {
        return $this->isActive() && $this->balance >= $amount;
    }
}