<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VirtualCardApplication extends Model
{
    protected $fillable = [
        'user_id', 'virtual_card_category_id', 'full_name', 'phone', 
        'address', 'city', 'state', 'zip_code', 'purpose', 
        'preferred_card_type', 'status', 'admin_notes', 'virtual_card_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function category()
    {
        return $this->belongsTo(VirtualCardCategory::class, 'virtual_card_category_id');
    }

    public function virtualCard()
    {
        return $this->belongsTo(VirtualCard::class);
    }
}