<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VirtualCardCategory extends Model
{
    protected $fillable = [
        'name', 'description', 'price', 'daily_limit', 'monthly_limit', 
        'annual_fee', 'features', 'status'
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'daily_limit' => 'decimal:2',
        'monthly_limit' => 'decimal:2',
        'annual_fee' => 'decimal:2',
        'features' => 'array'
    ];

    public function applications()
    {
        return $this->hasMany(VirtualCardApplication::class);
    }
}