<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VirtualCardTransaction extends Model
{
    protected $fillable = [
        'virtual_card_id', 'type', 'amount', 'description', 'reference', 'status'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    public function virtualCard()
    {
        return $this->belongsTo(VirtualCard::class);
    }
}