<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVirtualCardsTable extends Migration
{
    public function up()
    {
        Schema::create('virtual_cards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('card_number', 16)->unique();
            $table->string('card_holder_name');
            $table->string('expiry_month', 2);
            $table->string('expiry_year', 4);
            $table->string('cvv', 3);
            $table->decimal('balance', 15, 2)->default(0.00);
            $table->decimal('daily_limit', 15, 2)->default(1000.00);
            $table->decimal('monthly_limit', 15, 2)->default(10000.00);
            $table->enum('status', ['active', 'blocked', 'expired'])->default('active');
            $table->enum('card_type', ['visa', 'mastercard'])->default('visa');
            $table->timestamps();
            
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('virtual_cards');
    }
}