<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVirtualCardTransactionsTable extends Migration
{
    public function up()
    {
        Schema::create('virtual_card_transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('virtual_card_id');
            $table->enum('type', ['credit', 'debit']);
            $table->decimal('amount', 15, 2);
            $table->string('description');
            $table->string('reference')->unique();
            $table->enum('status', ['pending', 'completed', 'failed'])->default('completed');
            $table->timestamps();
            
            $table->foreign('virtual_card_id')->references('id')->on('virtual_cards')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('virtual_card_transactions');
    }
}