<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVirtualCardCategoriesTable extends Migration
{
    public function up()
    {
        Schema::create('virtual_card_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description');
            $table->decimal('price', 10, 2);
            $table->decimal('daily_limit', 15, 2)->default(1000.00);
            $table->decimal('monthly_limit', 15, 2)->default(10000.00);
            $table->decimal('annual_fee', 10, 2)->default(0.00);
            $table->json('features')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('virtual_card_categories');
    }
}