<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVirtualCardApplicationsTable extends Migration
{
    public function up()
    {
        Schema::create('virtual_card_applications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('virtual_card_category_id');
            $table->string('full_name');
            $table->string('phone');
            $table->text('address');
            $table->string('city');
            $table->string('state');
            $table->string('zip_code');
            $table->text('purpose');
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('admin_notes')->nullable();
            $table->unsignedBigInteger('virtual_card_id')->nullable();
            $table->timestamps();
            
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('virtual_card_category_id')->references('id')->on('virtual_card_categories');
            $table->foreign('virtual_card_id')->references('id')->on('virtual_cards')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('virtual_card_applications');
    }
}