@php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
@endphp
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Card Applications Management</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-5 row">
                    <div class="col-lg-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Pending Applications</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>User</th>
                                                <th class="d-none d-md-table-cell">Category</th>
                                                <th class="d-none d-lg-table-cell">Card Type</th>
                                                <th class="d-none d-md-table-cell">Fee Paid</th>
                                                <th>Status</th>
                                                <th class="d-none d-lg-table-cell">Applied</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($applications as $application)
                                            <tr>
                                                <td>
                                                    <strong>{{ $application->user->name }}</strong><br>
                                                    <small class="text-muted">{{ $application->user->email }}</small>
                                                    <div class="d-md-none mt-1">
                                                        <small class="text-info">{{ $application->category->name }}</small><br>
                                                        <small class="text-success">${{ number_format($application->category->price, 2) }}</small>
                                                    </div>
                                                </td>
                                                <td class="d-none d-md-table-cell">{{ $application->category->name }}</td>
                                                <td class="d-none d-lg-table-cell">
                                                    <span class="badge badge-info">{{ ucfirst(str_replace('_', ' ', $application->preferred_card_type)) }}</span>
                                                </td>
                                                <td class="d-none d-md-table-cell">${{ number_format($application->category->price, 2) }}</td>
                                                <td>
                                                    @if($application->status == 'pending')
                                                        <span class="badge badge-warning">Pending</span>
                                                    @elseif($application->status == 'approved')
                                                        <span class="badge badge-success">Approved</span>
                                                    @else
                                                        <span class="badge badge-danger">Rejected</span>
                                                    @endif
                                                </td>
                                                <td class="d-none d-lg-table-cell">{{ $application->created_at->format('M d, Y') }}</td>
                                                <td>
                                                    <div class="btn-group-vertical btn-group-sm d-lg-none">
                                                        @if($application->status == 'pending')
                                                        <button class="btn btn-success btn-sm mb-1" onclick="approveApplication({{ $application->id }})">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                        <button class="btn btn-danger btn-sm mb-1" onclick="rejectApplication({{ $application->id }})">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                        @endif
                                                        <button class="btn btn-info btn-sm" onclick="viewApplication({{ $application->id }})">
                                                            <i class="fas fa-eye"></i>
                                                        </button>
                                                    </div>
                                                    <div class="d-none d-lg-block">
                                                        @if($application->status == 'pending')
                                                        <button class="btn btn-sm btn-success" onclick="approveApplication({{ $application->id }})">
                                                            <i class="fas fa-check"></i> Approve
                                                        </button>
                                                        <button class="btn btn-sm btn-danger" onclick="rejectApplication({{ $application->id }})">
                                                            <i class="fas fa-times"></i> Reject
                                                        </button>
                                                        @endif
                                                        <button class="btn btn-sm btn-info" onclick="viewApplication({{ $application->id }})">
                                                            <i class="fas fa-eye"></i> View
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                            @empty
                                            <tr>
                                                <td colspan="7" class="text-center">No applications found</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Approve Modal -->
    <div class="modal fade" id="approveModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Approve Application</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="approveForm" method="POST">
                    @csrf
                    <div class="modal-body">
                        <p>Are you sure you want to approve this application? A virtual card will be generated for the user.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-check"></i> Approve & Generate Card
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div class="modal fade" id="rejectModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Application</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="rejectForm" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Reason for Rejection</label>
                            <textarea name="notes" class="form-control" rows="3" required placeholder="Please provide a reason for rejection..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-times"></i> Reject & Refund
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
    function approveApplication(id) {
        document.getElementById('approveForm').action = `{{ url('admin/virtual-card-applications') }}/${id}/approve`;
        $('#approveModal').modal('show');
    }

    function rejectApplication(id) {
        document.getElementById('rejectForm').action = `{{ url('admin/virtual-card-applications') }}/${id}/reject`;
        $('#rejectModal').modal('show');
    }

    function viewApplication(id) {
        window.location.href = `{{ url('admin/virtual-card-applications') }}/${id}`;
    }
    </script>
@endsection