@php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
@endphp
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Create Card Category</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-5 row">
                    <div class="col-lg-8 col-md-10 col-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Category Details</h4>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="{{ route('admin.virtual-card-categories.store') }}">
                                    @csrf
                                    <div class="row">
                                        <div class="form-group col-md-6">
                                            <label>Category Name</label>
                                            <input type="text" name="name" class="form-control" required>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label>Application Price ($)</label>
                                            <input type="number" name="price" class="form-control" step="0.01" min="0" required>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea name="description" class="form-control" rows="3" required></textarea>
                                    </div>

                                    <div class="row">
                                        <div class="form-group col-md-4">
                                            <label>Daily Limit ($)</label>
                                            <input type="number" name="daily_limit" class="form-control" step="0.01" min="0" value="1000" required>
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Monthly Limit ($)</label>
                                            <input type="number" name="monthly_limit" class="form-control" step="0.01" min="0" value="10000" required>
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Annual Fee ($)</label>
                                            <input type="number" name="annual_fee" class="form-control" step="0.01" min="0" value="0" required>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label>Status</label>
                                        <select name="status" class="form-control" required>
                                            <option value="active">Active</option>
                                            <option value="inactive">Inactive</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Create Category</button>
                                        <a href="{{ route('admin.virtual-card-categories.index') }}" class="btn btn-secondary">Cancel</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection