@php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
@endphp
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Create Virtual Card</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-5 row">
                    <div class="col-lg-8 col-md-10 col-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Card Details</h4>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="{{ route('admin.virtual-cards.store') }}">
                                    @csrf
                                    <div class="row">
                                        <div class="form-group col-md-6">
                                            <label>Select User</label>
                                            <select name="user_id" class="form-control" required>
                                                <option value="">Select User</option>
                                                @foreach($users as $user)
                                                    <option value="{{ $user->id }}">{{ $user->name }} ({{ $user->email }})</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label>Initial Balance</label>
                                            <input type="number" name="balance" class="form-control" step="0.01" min="0" value="0" required>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-md-6">
                                            <label>Daily Limit</label>
                                            <input type="number" name="daily_limit" class="form-control" step="0.01" min="0" value="1000" required>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label>Monthly Limit</label>
                                            <input type="number" name="monthly_limit" class="form-control" step="0.01" min="0" value="10000" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Create Virtual Card</button>
                                        <a href="{{ route('admin.virtual-cards.index') }}" class="btn btn-secondary">Cancel</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection