@php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
@endphp
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Virtual Cards Management</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-5 row">
                    <div class="mt-2 mb-3 col-lg-12">
                        <a class="btn btn-primary" href="{{ route('admin.virtual-cards.create') }}"><i class="fa fa-plus"></i> Create New Card</a>
                    </div>
                    <div class="col-lg-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Virtual Cards</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>User</th>
                                                <th class="d-none d-md-table-cell">Card Number</th>
                                                <th class="d-none d-lg-table-cell">Balance</th>
                                                <th>Status</th>
                                                <th class="d-none d-lg-table-cell">Created</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($cards as $card)
                                            <tr>
                                                <td>
                                                    <strong>{{ $card->user->name }}</strong><br>
                                                    <small class="text-muted">{{ $card->user->email }}</small>
                                                    <div class="d-md-none mt-1">
                                                        <small class="text-info">{{ $card->masked_card_number }}</small><br>
                                                        <small class="text-success">${{ number_format($card->balance, 2) }}</small>
                                                    </div>
                                                </td>
                                                <td class="d-none d-md-table-cell">{{ $card->masked_card_number }}</td>
                                                <td class="d-none d-lg-table-cell">${{ number_format($card->balance, 2) }}</td>
                                                <td>
                                                    <span class="badge badge-{{ $card->status == 'active' ? 'success' : 'danger' }}">
                                                        {{ ucfirst($card->status) }}
                                                    </span>
                                                </td>
                                                <td class="d-none d-lg-table-cell">{{ $card->created_at->format('M d, Y') }}</td>
                                                <td>
                                                    <div class="btn-group-vertical btn-group-sm d-lg-none">
                                                        <form method="POST" action="{{ route('admin.virtual-cards.update-status', $card->id) }}" class="d-inline">
                                                            @csrf
                                                            <input type="hidden" name="status" value="{{ $card->status == 'active' ? 'blocked' : 'active' }}">
                                                            <button class="btn btn-sm btn-{{ $card->status == 'active' ? 'warning' : 'success' }} mb-1">
                                                                <i class="fa fa-{{ $card->status == 'active' ? 'pause' : 'play' }}"></i>
                                                            </button>
                                                        </form>
                                                        <form method="POST" action="{{ route('admin.virtual-cards.destroy', $card->id) }}" class="d-inline">
                                                            @csrf @method('DELETE')
                                                            <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this card?')">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                    <div class="d-none d-lg-block">
                                                        <form method="POST" action="{{ route('admin.virtual-cards.update-status', $card->id) }}" class="d-inline">
                                                            @csrf
                                                            <input type="hidden" name="status" value="{{ $card->status == 'active' ? 'blocked' : 'active' }}">
                                                            <button class="btn btn-sm btn-{{ $card->status == 'active' ? 'warning' : 'success' }}">
                                                                {{ $card->status == 'active' ? 'Block' : 'Activate' }}
                                                            </button>
                                                        </form>
                                                        <form method="POST" action="{{ route('admin.virtual-cards.destroy', $card->id) }}" class="d-inline">
                                                            @csrf @method('DELETE')
                                                            <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this card?')">Delete</button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                            @empty
                                            <tr>
                                                <td colspan="6" class="text-center">No virtual cards found</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection