<?php

use App\Http\Controllers\Admin\VirtualCardController as AdminVirtualCardController;
use App\Http\Controllers\Admin\VirtualCardCategoryController;
use App\Http\Controllers\User\VirtualCardController as UserVirtualCardController;

// Admin Virtual Cards Routes
Route::middleware(['auth:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::prefix('virtual-cards')->name('virtual-cards.')->group(function () {
        Route::get('/', [AdminVirtualCardController::class, 'index'])->name('index');
        Route::get('/create', [AdminVirtualCardController::class, 'create'])->name('create');
        Route::post('/', [AdminVirtualCardController::class, 'store'])->name('store');
        Route::post('/{id}/update-status', [AdminVirtualCardController::class, 'updateStatus'])->name('update-status');
        Route::post('/{id}/update-balance', [AdminVirtualCardController::class, 'updateBalance'])->name('update-balance');
        Route::delete('/{id}', [AdminVirtualCardController::class, 'destroy'])->name('destroy');
    });
    
    Route::prefix('virtual-card-categories')->name('virtual-card-categories.')->group(function () {
        Route::get('/', [VirtualCardCategoryController::class, 'index'])->name('index');
        Route::get('/create', [VirtualCardCategoryController::class, 'create'])->name('create');
        Route::post('/', [VirtualCardCategoryController::class, 'store'])->name('store');
        Route::post('/{id}/toggle', [VirtualCardCategoryController::class, 'toggleStatus'])->name('toggle');
    });
    
    Route::prefix('virtual-card-applications')->name('virtual-card-applications.')->group(function () {
        Route::get('/', [VirtualCardCategoryController::class, 'applications'])->name('index');
        Route::get('/{id}', [VirtualCardCategoryController::class, 'viewApplication'])->name('show');
        Route::post('/{id}/approve', [VirtualCardCategoryController::class, 'approveApplication'])->name('approve');
        Route::post('/{id}/reject', [VirtualCardCategoryController::class, 'rejectApplication'])->name('reject');
    });
});

// User Virtual Cards Routes
Route::middleware(['auth', 'verified'])->prefix('user')->name('user.')->group(function () {
    Route::prefix('virtual-cards')->name('virtual-cards.')->group(function () {
        Route::get('/', [UserVirtualCardController::class, 'index'])->name('index');
        Route::get('/categories', [UserVirtualCardController::class, 'categories'])->name('categories');
        Route::get('/apply/{category}', [UserVirtualCardController::class, 'apply'])->name('apply');
        Route::post('/submit-application', [UserVirtualCardController::class, 'submitApplication'])->name('submit-application');
        Route::post('/{id}/fund', [UserVirtualCardController::class, 'fundCard'])->name('fund');
        Route::post('/{id}/withdraw', [UserVirtualCardController::class, 'withdrawCard'])->name('withdraw');
        Route::post('/{id}/block', [UserVirtualCardController::class, 'block'])->name('block');
        Route::post('/{id}/unblock', [UserVirtualCardController::class, 'unblock'])->name('unblock');
    });
});