<?php $__env->startSection('title', 'Apply for Card'); ?>
<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6 max-w-2xl">
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">Apply for <?php echo e($category->name); ?></h1>
        <p class="text-gray-600 dark:text-gray-400">Complete the form below to apply for your virtual card</p>
    </div>

    <!-- Category Info -->
    <div class="bg-blue-50 dark:bg-blue-900/20 rounded-lg p-4 mb-6">
        <div class="flex justify-between items-center">
            <div>
                <h3 class="font-semibold text-blue-900 dark:text-blue-100"><?php echo e($category->name); ?></h3>
                <p class="text-sm text-blue-700 dark:text-blue-300">Application Fee: $<?php echo e(number_format($category->price, 2)); ?></p>
            </div>
            <div class="text-right">
                <p class="text-sm text-blue-700 dark:text-blue-300">Your Balance: $<?php echo e(number_format(Auth::user()->account_bal, 2)); ?></p>
            </div>
        </div>
    </div>

    <?php if(Auth::user()->account_bal < $category->price): ?>
    <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4 mb-6">
        <p class="text-red-700 dark:text-red-300">
            <i class="fas fa-exclamation-triangle mr-2"></i>
            Insufficient balance! You need $<?php echo e(number_format($category->price, 2)); ?> to apply for this card.
        </p>
    </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('user.virtual-cards.submit-application')); ?>" class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="category_id" value="<?php echo e($category->id); ?>">

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Full Name</label>
                <input type="text" name="full_name" value="<?php echo e(Auth::user()->name); ?>" required
                       class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Phone Number</label>
                <input type="tel" name="phone" required
                       class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white">
            </div>
        </div>

        <div class="mt-6">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Address</label>
            <textarea name="address" rows="3" required
                      class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white"></textarea>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">City</label>
                <input type="text" name="city" required
                       class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">State</label>
                <input type="text" name="state" required
                       class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">ZIP Code</label>
                <input type="text" name="zip_code" required
                       class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white">
            </div>
        </div>

        <div class="mt-6">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Preferred Card Type</label>
            <select name="preferred_card_type" required
                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white">
                <option value="visa">Visa</option>
                <option value="mastercard">Mastercard</option>
                <option value="american_express">American Express</option>
            </select>
        </div>

        <div class="mt-6">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Purpose of Card</label>
            <textarea name="purpose" rows="3" placeholder="Describe how you plan to use this virtual card..." required
                      class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white"></textarea>
        </div>

        <div class="mt-8 flex justify-between">
            <a href="<?php echo e(route('user.virtual-cards.categories')); ?>" 
               class="px-6 py-3 border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700">
                Back to Categories
            </a>
            
            <button type="submit" 
                    <?php echo e(Auth::user()->account_bal < $category->price ? 'disabled' : ''); ?>

                    class="px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 disabled:opacity-50 disabled:cursor-not-allowed">
                Submit Application ($<?php echo e(number_format($category->price, 2)); ?>)
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dasht', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp80\htdocs\ttt2\copy\resources\views/user/virtual-cards/apply.blade.php ENDPATH**/ ?>