<?php $__env->startSection('title', 'Virtual Cards'); ?>
<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">My Virtual Cards</h1>
        <a href="<?php echo e(route('user.virtual-cards.categories')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
            Apply for New Card
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border">
            <div class="flex items-center">
                <div class="p-2 bg-blue-100 rounded-lg">
                    <i class="fas fa-credit-card text-blue-600"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Total Cards</p>
                    <p class="text-xl font-bold text-gray-900 dark:text-white"><?php echo e($cards->count()); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border">
            <div class="flex items-center">
                <div class="p-2 bg-green-100 rounded-lg">
                    <i class="fas fa-dollar-sign text-green-600"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Total Balance</p>
                    <p class="text-xl font-bold text-gray-900 dark:text-white">$<?php echo e(number_format($cards->sum('balance'), 2)); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border">
            <div class="flex items-center">
                <div class="p-2 bg-yellow-100 rounded-lg">
                    <i class="fas fa-clock text-yellow-600"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Pending</p>
                    <p class="text-xl font-bold text-gray-900 dark:text-white"><?php echo e($applications->where('status', 'pending')->count()); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border">
            <div class="flex items-center">
                <div class="p-2 bg-green-100 rounded-lg">
                    <i class="fas fa-check text-green-600"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Approved</p>
                    <p class="text-xl font-bold text-gray-900 dark:text-white"><?php echo e($applications->where('status', 'approved')->count()); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border">
            <div class="flex items-center">
                <div class="p-2 bg-red-100 rounded-lg">
                    <i class="fas fa-times text-red-600"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Rejected</p>
                    <p class="text-xl font-bold text-gray-900 dark:text-white"><?php echo e($applications->where('status', 'rejected')->count()); ?></p>
                </div>
            </div>
        </div>
    </div>

  

    <!-- Active Cards -->
    <?php if($cards->count() > 0): ?>
    <div class="mb-6">
        <h2 class="text-lg font-semibold mb-4 text-gray-900 dark:text-white">My Cards</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card-template <?php echo e($card->card_type); ?>-card rounded-xl p-6 text-white relative overflow-hidden">
                <div class="flex justify-between items-start mb-4">
                    <div class="card-logo">
                        <?php if($card->card_type == 'visa'): ?>
                            <span class="visa-logo">VISA</span>
                        <?php elseif($card->card_type == 'mastercard'): ?>
                            <div class="mastercard-logo">
                                <div class="mc-circle red"></div>
                                <div class="mc-circle yellow"></div>
                            </div>
                        <?php else: ?>
                            <span class="amex-logo">AMERICAN EXPRESS</span>
                        <?php endif; ?>
                    </div>
                    <div class="text-xs px-2 py-1 rounded-full <?php echo e($card->status == 'active' ? 'bg-green-500' : 'bg-red-500'); ?>">
                        <?php echo e(ucfirst($card->status)); ?>

                    </div>
                </div>

                <?php if($card->card_type == 'visa'): ?>
                    <div class="chip visa-chip mb-4"></div>
                <?php elseif($card->card_type == 'mastercard'): ?>
                    <div class="chip mc-chip mb-4"></div>
                <?php else: ?>
                    <div class="chip amex-chip mb-4"></div>
                <?php endif; ?>

                <div class="mb-4">
                    <div class="text-lg font-mono tracking-wider"><?php echo e($card->masked_card_number); ?></div>
                </div>

                <div class="flex justify-between items-end">
                    <div>
                        <div class="text-xs opacity-80"><?php echo e($card->card_type == 'american_express' ? 'MEMBER SINCE' : 'CARD HOLDER'); ?></div>
                        <div class="text-sm font-semibold"><?php echo e(strtoupper($card->card_holder_name)); ?></div>
                    </div>
                    <div>
                        <div class="text-xs opacity-80"><?php echo e($card->card_type == 'american_express' ? 'EXPIRES' : 'VALID THRU'); ?></div>
                        <div class="text-sm"><?php echo e($card->expiry_month); ?>/<?php echo e($card->expiry_year); ?></div>
                    </div>
                    <div>
                        <div class="text-xs opacity-80"><?php echo e($card->card_type == 'american_express' ? 'CID' : 'CVV'); ?></div>
                        <div class="text-sm font-mono"><?php echo e($card->cvv); ?></div>
                    </div>
                </div>

                <div class="mt-4 pt-4 border-t border-white border-opacity-20">
                    <div class="flex justify-between items-center">
                        <div>
                            <div class="text-xs opacity-80">Balance</div>
                            <div class="text-xl font-bold">$<?php echo e(number_format($card->balance, 2)); ?></div>
                        </div>
                        <div class="flex space-x-2">
                            <button onclick="showCardDetails(<?php echo e($card->id); ?>)" class="bg-white bg-opacity-20 px-3 py-1 rounded text-xs">
                                View
                            </button>
                            <button onclick="showFundModal(<?php echo e($card->id); ?>)" class="bg-white bg-opacity-20 px-3 py-1 rounded text-xs">
                                Fund
                            </button>
                            <?php if($card->balance > 0): ?>
                            <button onclick="showWithdrawModal(<?php echo e($card->id); ?>)" class="bg-white bg-opacity-20 px-3 py-1 rounded text-xs">
                                Withdraw
                            </button>
                            <?php endif; ?>
                            <?php if($card->status == 'active'): ?>
                            <form method="POST" action="<?php echo e(route('user.virtual-cards.block', $card->id)); ?>" class="inline">
                                <?php echo csrf_field(); ?>
                                <button class="bg-red-500 px-3 py-1 rounded text-xs">Block</button>
                            </form>
                            <?php else: ?>
                            <form method="POST" action="<?php echo e(route('user.virtual-cards.unblock', $card->id)); ?>" class="inline">
                                <?php echo csrf_field(); ?>
                                <button class="bg-green-500 px-3 py-1 rounded text-xs">Unblock</button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <?php if($cards->count() == 0 && $applications->count() == 0): ?>
    <div class="text-center py-12">
        <div class="text-gray-500 dark:text-gray-400 mb-4">
            <i class="fas fa-credit-card text-6xl mb-4"></i>
            <p class="text-xl">No virtual cards yet</p>
            <p>Apply for your first virtual card to get started</p>
        </div>
    </div>
    <?php endif; ?>

    <!-- Card Details Modal -->
    <div id="cardDetailsModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
        <div class="bg-white dark:bg-gray-800 rounded-lg p-6 w-96">
            <h3 class="text-lg font-semibold mb-4 text-gray-900 dark:text-white">Card Details</h3>
            <div id="cardDetailsContent" class="space-y-3">
                <!-- Card details will be populated here -->
            </div>
            <div class="flex justify-end mt-4">
                <button onclick="closeCardDetailsModal()" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">
                    Close
                </button>
            </div>
        </div>
    </div>

    <!-- Fund Modal -->
    <div id="fundModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
        <div class="bg-white dark:bg-gray-800 rounded-lg p-6 w-96">
            <h3 class="text-lg font-semibold mb-4 text-gray-900 dark:text-white">Fund Virtual Card</h3>
            <form id="fundForm" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Amount</label>
                    <input type="number" name="amount" step="0.01" min="1" required 
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="flex justify-end space-x-3">
                    <button type="button" onclick="closeFundModal()" class="px-4 py-2 text-gray-600 hover:text-gray-800">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                        Fund Card
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Withdraw Modal -->
    <div id="withdrawModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
        <div class="bg-white dark:bg-gray-800 rounded-lg p-6 w-96">
            <h3 class="text-lg font-semibold mb-4 text-gray-900 dark:text-white">Withdraw from Virtual Card</h3>
            <form id="withdrawForm" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Amount</label>
                    <input type="number" name="amount" step="0.01" min="1" required 
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="flex justify-end space-x-3">
                    <button type="button" onclick="closeWithdrawModal()" class="px-4 py-2 text-gray-600 hover:text-gray-800">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                        Withdraw
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
.visa-card {
    background: linear-gradient(135deg, #1434A4 0%, #0F4C75 50%, #1E3A8A 100%);
    position: relative;
}

.visa-card::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 100px;
    height: 100px;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    border-radius: 50%;
}

.visa-logo {
    font-size: 28px;
    font-weight: 700;
    font-style: italic;
    color: white;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
    letter-spacing: 2px;
}

.visa-chip {
    background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
    border: 2px solid #B8860B;
    box-shadow: inset 0 2px 4px rgba(0,0,0,0.2);
}

.visa-chip::before {
    content: '';
    position: absolute;
    top: 4px;
    left: 4px;
    right: 4px;
    bottom: 4px;
    background: linear-gradient(135deg, rgba(255,255,255,0.3) 0%, rgba(255,255,255,0.1) 100%);
    border-radius: 2px;
}

.mastercard-card {
    background: linear-gradient(135deg, #EB001B 0%, #F79E1B 50%, #FF5F00 100%);
    position: relative;
}

.mastercard-card::before {
    content: '';
    position: absolute;
    top: -50px;
    right: -50px;
    width: 150px;
    height: 150px;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 60%);
    border-radius: 50%;
}

.mastercard-logo {
    display: flex;
    align-items: center;
    position: relative;
}

.mc-circle {
    width: 24px;
    height: 24px;
    border-radius: 50%;
    position: relative;
}

.mc-circle.red {
    background: #EB001B;
    z-index: 2;
    box-shadow: 2px 0 4px rgba(0,0,0,0.2);
}

.mc-circle.yellow {
    background: #F79E1B;
    margin-left: -12px;
    z-index: 1;
    box-shadow: -2px 0 4px rgba(0,0,0,0.2);
}

.mc-chip {
    background: linear-gradient(135deg, #C0C0C0 0%, #E8E8E8 50%, #A8A8A8 100%);
    border: 2px solid #888;
    box-shadow: inset 0 2px 4px rgba(0,0,0,0.3);
}

.mc-chip::before {
    content: '';
    position: absolute;
    top: 4px;
    left: 4px;
    right: 4px;
    bottom: 4px;
    background: linear-gradient(135deg, rgba(255,255,255,0.4) 0%, rgba(255,255,255,0.1) 100%);
    border-radius: 2px;
}

.american_express-card {
    background: linear-gradient(135deg, #006FCF 0%, #012169 50%, #003366 100%);
    position: relative;
}

.american_express-card::before {
    content: '';
    position: absolute;
    top: 20px;
    right: 20px;
    width: 80px;
    height: 80px;
    background: radial-gradient(circle, rgba(255,255,255,0.08) 0%, transparent 70%);
    border-radius: 50%;
}

.amex-logo {
    font-size: 14px;
    font-weight: 700;
    letter-spacing: 1.5px;
    color: white;
    text-shadow: 1px 1px 3px rgba(0,0,0,0.4);
    font-family: 'Arial', sans-serif;
}

.amex-chip {
    background: linear-gradient(135deg, #00D4AA 0%, #00B894 50%, #00A085 100%);
    border: 2px solid #008B75;
    box-shadow: inset 0 2px 4px rgba(0,0,0,0.25);
}

.amex-chip::before {
    content: '';
    position: absolute;
    top: 4px;
    left: 4px;
    right: 4px;
    bottom: 4px;
    background: linear-gradient(135deg, rgba(255,255,255,0.3) 0%, rgba(255,255,255,0.1) 100%);
    border-radius: 2px;
}

.amex-chip::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 14px;
    height: 10px;
    background: linear-gradient(90deg, #008B75 0%, #006B5B 100%);
    transform: translate(-50%, -50%);
    border-radius: 1px;
}

.chip {
    width: 40px;
    height: 30px;
    border-radius: 6px;
    position: relative;
}
</style>

<script>
const cards = <?php echo json_encode($cards->map(function($card) {
    return [
        'id' => $card->id,
        'card_number' => $card->card_number,
        'card_holder_name' => $card->card_holder_name,
        'expiry_month' => $card->expiry_month,
        'expiry_year' => $card->expiry_year,
        'cvv' => $card->cvv,
        'card_type' => $card->card_type,
        'balance' => $card->balance
    ];
})); ?>;

function showCardDetails(cardId) {
    const card = cards.find(c => c.id === cardId);
    if (card) {
        document.getElementById('cardDetailsContent').innerHTML = `
            <div class="border-b pb-2">
                <label class="text-sm font-medium text-gray-600 dark:text-gray-400">Card Number</label>
                <div class="font-mono text-lg">${card.card_number}</div>
            </div>
            <div class="border-b pb-2">
                <label class="text-sm font-medium text-gray-600 dark:text-gray-400">Card Holder</label>
                <div class="font-semibold">${card.card_holder_name}</div>
            </div>
            <div class="flex space-x-4 border-b pb-2">
                <div>
                    <label class="text-sm font-medium text-gray-600 dark:text-gray-400">Expires</label>
                    <div class="font-mono">${card.expiry_month}/${card.expiry_year}</div>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-600 dark:text-gray-400">CVV</label>
                    <div class="font-mono">${card.cvv}</div>
                </div>
            </div>
            <div>
                <label class="text-sm font-medium text-gray-600 dark:text-gray-400">Card Type</label>
                <div class="capitalize">${card.card_type}</div>
            </div>
            <div>
                <label class="text-sm font-medium text-gray-600 dark:text-gray-400">Balance</label>
                <div class="text-xl font-bold text-green-600">$${parseFloat(card.balance).toFixed(2)}</div>
            </div>
        `;
        document.getElementById('cardDetailsModal').classList.remove('hidden');
        document.getElementById('cardDetailsModal').classList.add('flex');
    }
}

function closeCardDetailsModal() {
    document.getElementById('cardDetailsModal').classList.add('hidden');
    document.getElementById('cardDetailsModal').classList.remove('flex');
}

function showFundModal(cardId) {
    document.getElementById('fundForm').action = `<?php echo e(url('user/virtual-cards')); ?>/${cardId}/fund`;
    document.getElementById('fundModal').classList.remove('hidden');
    document.getElementById('fundModal').classList.add('flex');
}

function closeFundModal() {
    document.getElementById('fundModal').classList.add('hidden');
    document.getElementById('fundModal').classList.remove('flex');
}

function showWithdrawModal(cardId) {
    document.getElementById('withdrawForm').action = `<?php echo e(url('user/virtual-cards')); ?>/${cardId}/withdraw`;
    document.getElementById('withdrawModal').classList.remove('hidden');
    document.getElementById('withdrawModal').classList.add('flex');
}

function closeWithdrawModal() {
    document.getElementById('withdrawModal').classList.add('hidden');
    document.getElementById('withdrawModal').classList.remove('flex');
}
</script>

  <!-- Applications Status -->
    <?php if($applications->count() > 0): ?>
    <div class="mb-6">
        <h2 class="text-lg font-semibold mb-4 text-gray-900 dark:text-white">My Applications</h2>
        <div class="grid gap-4">
            <?php $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border">
                <div class="flex justify-between items-start">
                    <div>
                        <h3 class="font-semibold text-gray-900 dark:text-white"><?php echo e($application->category->name); ?></h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Applied: <?php echo e($application->created_at->format('M d, Y')); ?></p>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Fee Paid: $<?php echo e(number_format($application->category->price, 2)); ?></p>
                    </div>
                    <span class="px-3 py-1 rounded-full text-sm font-medium
                        <?php echo e($application->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : 
                           ($application->status == 'approved' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800')); ?>">
                        <?php echo e(ucfirst($application->status)); ?>

                    </span>
                </div>
                <?php if($application->admin_notes): ?>
                <div class="mt-2 p-2 bg-gray-100 dark:bg-gray-700 rounded">
                    <p class="text-sm text-gray-700 dark:text-gray-300">Admin Notes: <?php echo e($application->admin_notes); ?></p>
                </div>
                <?php endif; ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dasht', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp80\htdocs\ttt2\copy\resources\views/user/virtual-cards/index.blade.php ENDPATH**/ ?>