-- Virtual Cards Database Setup
-- Run this in phpMyAdmin or MySQL command line

-- Create virtual_cards table
CREATE TABLE IF NOT EXISTS `virtual_cards` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `card_number` varchar(16) NOT NULL,
  `card_holder_name` varchar(255) NOT NULL,
  `expiry_month` varchar(2) NOT NULL,
  `expiry_year` varchar(4) NOT NULL,
  `cvv` varchar(3) NOT NULL,
  `balance` decimal(15,2) DEFAULT 0.00,
  `daily_limit` decimal(15,2) DEFAULT 1000.00,
  `monthly_limit` decimal(15,2) DEFAULT 10000.00,
  `status` enum('active','blocked','expired') DEFAULT 'active',
  `card_type` enum('visa','mastercard','american_express') DEFAULT 'visa',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `card_number` (`card_number`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create virtual_card_transactions table
CREATE TABLE IF NOT EXISTS `virtual_card_transactions` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtual_card_id` bigint(20) UNSIGNED NOT NULL,
  `type` enum('credit','debit') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `description` varchar(255) NOT NULL,
  `reference` varchar(255) NOT NULL,
  `status` enum('pending','completed','failed') DEFAULT 'completed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `virtual_card_id` (`virtual_card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create virtual_card_categories table
CREATE TABLE IF NOT EXISTS `virtual_card_categories` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `daily_limit` decimal(15,2) DEFAULT 1000.00,
  `monthly_limit` decimal(15,2) DEFAULT 10000.00,
  `annual_fee` decimal(10,2) DEFAULT 0.00,
  `features` json DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create virtual_card_applications table
CREATE TABLE IF NOT EXISTS `virtual_card_applications` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `virtual_card_category_id` bigint(20) UNSIGNED NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `zip_code` varchar(255) NOT NULL,
  `purpose` text NOT NULL,
  `status` enum('pending','approved','rejected') DEFAULT 'pending',
  `admin_notes` text DEFAULT NULL,
  `virtual_card_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `virtual_card_category_id` (`virtual_card_category_id`),
  KEY `virtual_card_id` (`virtual_card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add card_type field to applications table
ALTER TABLE `virtual_card_applications` ADD `preferred_card_type` enum('visa','mastercard','american_express') DEFAULT 'visa' AFTER `purpose`;

-- Insert sample card categories
INSERT INTO `virtual_card_categories` (`name`, `description`, `price`, `daily_limit`, `monthly_limit`, `annual_fee`, `status`) VALUES
('Basic Card', 'Standard virtual card for everyday use', 25.00, 500.00, 5000.00, 0.00, 'active'),
('Premium Card', 'Enhanced virtual card with higher limits', 50.00, 2000.00, 20000.00, 25.00, 'active'),
('Business Card', 'Virtual card designed for business transactions', 100.00, 5000.00, 50000.00, 50.00, 'active');